/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.api.modelo.validacion;

import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.EstadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidableContexto;
import ec.gob.sri.dimm.api.modelo.validacion.ProveedorContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.wb.swt.ResourceManager;

public class ListenerValidacionModeloPaginaAsistente
implements PropertyChangeListener {
    private final InformacionValidable modeloDatos;
    private final PaginaAsistente paginaAsistente;

    public ListenerValidacionModeloPaginaAsistente(InformacionValidable modeloDatos, PaginaAsistente paginaAsistente) {
        this.modeloDatos = modeloDatos;
        this.paginaAsistente = paginaAsistente;
    }

    public ListenerValidacionModeloPaginaAsistente(InformacionValidableContexto modeloDatos, ContextoValidacion contexto, PaginaAsistente paginaAsistente) {
        this(modeloDatos, paginaAsistente);
        modeloDatos.setContextoValidacion(contexto);
    }

    public ListenerValidacionModeloPaginaAsistente(InformacionValidableContexto modeloDatos, ProveedorContextoValidacion proveedorContexto, PaginaAsistente paginaAsistente) {
        this(modeloDatos, paginaAsistente);
        modeloDatos.setProveedorContextoValidacion(proveedorContexto);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ResultadoValidacion resultado = this.modeloDatos.validar();
        boolean exitoso = resultado.esEstadoExitoso();
        if (exitoso) {
            this.ejecutarValidacionFinal(resultado);
            exitoso = resultado.esEstadoExitoso();
        }
        if (exitoso) {
            this.paginaAsistente.setImageDescriptor(ResourceManager.getPluginImageDescriptor("ec.gob.sri.dimm.api", "iconos/logowizards.jpg"));
            this.paginaAsistente.setErrorMessage(null);
            this.paginaAsistente.setMessage(null);
            this.paginaAsistente.setPageComplete(true);
            return;
        }
        if (resultado.getEstado() == EstadoValidacion.FALLIDO) {
            this.paginaAsistente.setImageDescriptor(ResourceManager.getPluginImageDescriptor("ec.gob.sri.dimm.api", "iconos/logowizards.jpg"));
            this.paginaAsistente.setMessage(null);
            this.paginaAsistente.setErrorMessage(resultado.getMensaje());
            this.paginaAsistente.setPageComplete(false);
        } else if (resultado.getEstado() == EstadoValidacion.ADVERTENCIA) {
            if (this.paginaAsistente.getName().equals("ParticipacionIdentificacion")) {
                this.paginaAsistente.setImageDescriptor(ResourceManager.getPluginImageDescriptor("ec.gob.sri.dimm.api", "iconos/logowizards_advertencia.jpg"));
            }
            this.paginaAsistente.setErrorMessage(null);
            this.paginaAsistente.setMessage(resultado.getMensaje(), 2);
            this.paginaAsistente.setPageComplete(true);
        }
    }

    protected void ejecutarValidacionFinal(ResultadoValidacion resultado) {
    }
}

